; 30-Aug-06 NEHolt; minor change for mapping wire layers from old to new WD_M block's settings
; 17-Aug-05 NEHolt; added processing of schematic WIRELAYS wire layer assignments
; 16-Jul-04 PanQ; Change to Support MDI
; 21-May-04 NEHolt ; renamed error handler, globalized RENAME command's keyword
; 31-Mar-04 LeeH; Globalization of strings
; 03-Dec-02 NEHolt cleanup
; 04-Feb-99 NEHolt, N8 Solutions, Inc  n8holt@cs.com
; ----    S W A P _ W D M . L S P   ---
; PURPOSE: can be used to swap out WD_M block and replace with new
;   version. Program also scans drawing for SRC/DEST and TERM symbols
;   that carry a WIRENO attrib and moves these wire num attributes to
;   a special new layer category given by new WD_M's WIREREF_LAY attrib
;   value (if present).
;
; This utility has four possible entry points (entered at "Command:" prompt)
;   SCHEMATIC DWGS:
;   "swap_wdm" -- swap wd_m block and convert to new block's layer names
;   "swap_wdm_keep" -- swap wd_m block but keep drawing's existing layer names
;   PANEL DWGS:
;   "swap_pnlm" -- swap wd_pnlm block and convert to new block's layer names
;   "swap_pnlm_keep" -- swap wd_pnlm block but keep drawing's existing layer names
;
; ----
(defun swap_wdm_cserr (s) ; ** 21-May-04 NEHolt renamed
; *** 31-Mar-04 LeeH
;  (if (/= s "Function cancelled")
;      (princ (strcat "\nError: " s))
;  )
  (if (/= s (c:wd_msg "GEN036" nil "Function cancelled"))
      (princ (strcat "\n" (c:wd_msg "SS2DWG011" nil "Error:") " " s))
  )
  (command "_.UNDO" "_E")
  (if #cmdecho (setvar "CMDECHO" #cmdecho))      ; Restore saved modes
  (setq *error* err_old)            ; Restore standard *error* handler
  (princ)
)
; --
(defun wd_get_attr_val_nam_en ( x_en attr / str atnam enn edd hit)
  ; Assumes "x_en" = block name
  ; "attr" name may contain wild cards
  (if (AND x_en (setq enn (entnext x_en))) (setq edd (entget enn)))
  (setq atnam nil)
  (setq str nil)
  (setq x_en nil)
  (setq hit nil) ; ** 22-Dec-98
  (while (AND enn (not x_en) (/= (cdr (assoc 0 edd)) "SEQEND") (not hit) ; ** 22-Dec-98
           (/= (cdr (assoc 0 edd)) "INSERT") )
    (if (= (cdr (assoc 0 edd)) "ATTRIB")
      (progn
        (setq atnam (cdr (assoc 2 edd)))
        (if (wcmatch atnam attr)
          (progn
            (setq x_en enn)
            (setq str (cdr (assoc 1 edd))) ; get attrib value
            (setq hit 1) ; ** 22-Dec-98 NEHolt
    ) ) ) )
    (if (setq enn (entnext enn)) (setq edd (entget enn)))
  )
  (list x_en atnam str) ; return the attribute's ent name,nam,value
)
; --  M A I N    P R O G R A M  ---
(defun do_swap_wdm ( todo which / ss ben x new_wdm_path val newed en ed slen ix
                     symnam oldnams newnams cnt blktodo
                     path
                     edd newben hit existing_laynam newnam lcnt swap_wd_m_wirelay_lst old_wd_m
                     oldnam old_wd_m_wirelay_lst wcnt default_wirelay_nam
                     wildcard_hit existing_wiretype_lst)
; **                     
  ; "todo" = 0 to swap block but keep drawing's existing layer names
  ;        = 1 to swap and convert to new layer names carried on new wd_m.dwg
  ; "which" = "S" for wd_m swap, = "P" for wd_pnlm swap
  (setq err_old *error*) ; Save old error handler
  (setq *error* swap_wdm_cserr) ; New error handler ; ** 21-May-04 NEHolt renamed 
  (setq #cmdecho (getvar "CMDECHO"))
  (setvar "CMDECHO" 0)
  (setq wcnt 0) ; ** 17-Aug-05 NEHolt
  
  ;16-Jul-2004 PanQ, Change for MDI
  (if (= (getvar "SDI") 1)
    (setvar "LISPINIT" 0) ; preserve values in case of batch run
  )

  
  ; This plus an UNDO END at end of program provides complete UNDO
  (command "_.UNDO" "_MARK")
  (command "_.UNDO" "_BEGIN") ; ** 21-May-04 NEHolt chg keyword from _GROUP to _BEGIN
  ; Look for WD_M or WD_PNLM block
  (cond
    ((= which "S")
      (setq ss (ssget "_X" '((-4 . "<AND")(0 . "INSERT")(2 . "WD_M")(-4 . "AND>"))))
      (setq blktodo "WD_M")
      ; Doing "S" but path held in memory is for previous "P" run
      (if (= GBL_swap_wdm "P") (setq GBL_swap_wdm_path nil)) ; reset from previous run
    )
    ((= which "P")
      (setq ss (ssget "_X" '((-4 . "<AND")(0 . "INSERT")(2 . "WD_PNLM")(-4 . "AND>"))))
      (setq blktodo "WD_PNLM")
      ; Doing "P" but path held in memory is for previous "S" run
      (if (= GBL_swap_wdm "S") (setq GBL_swap_wdm_path nil)) ; reset from previous run
    )
  )
  (setq GBL_swap_wdm which) ; remember what is being done
  (if (= ss nil)
; *** 31-Mar-04 LeeH
;    (princ (strcat "\nNo existing " blktodo " block not found on drawing"))
    (princ (strcat "\n" (c:wd_msg "SWAP033" (list blktodo) "No existing %1 block found on drawing")))   ; ** 01-Apr-04 LeeH - rephrased
  ; ELSE
    (progn ; assume 1st or only his is the one to process
      (setq ben (ssname ss 0))
      ; Make sure path to new version of WD_M block is pointed to by this
      ; value below
      (if (not GBL_swap_wdm_path) ; global in case run in batch mode
        (progn
        
; ** 02-Apr-04 NEHolt        
          ; Look for target BLOCK in current AcadE search paths. If found then display this as the
          ; default starting folder in the file selection dialog below
          (if (setq x (wd_fio_does_block_exist_disk blktodo))
            (setq path x)
          ; ELSE
            (setq path blktodo)
          )        
          (setq x (getfiled (c:wd_msg "SWAP045" (list blktodo blktodo) "Select the %1.dwg Drawing to Use as the New %1 Block in this drawing") ; ** 12-Jan-06 NEHolt capitalization
                 path "dwg" 10))
;                 blktodo "dwg" 10))
; **                 
          (if (= blktodo "WD_M")
            (progn
              (if x (setq x (findfile x)))
              (if x (setq GBL_swap_wdm_path (substr x 1 (- (strlen x) 8))))
            )
          ; ELSE
            (progn
              (if x (setq x (findfile x)))
              (if x (setq GBL_swap_wdm_path (substr x 1 (- (strlen x) 11))))
            )
          )
      ) )

      (cond
        ((= GBL_swap_wdm_path nil)
          (setq todo nil) ; failure
        )
        ((= todo 0) ; retain old layer names found on existing WD_M
          ; Read in list of attrib values from existing WD_M block insert
          ; Now swap out the block
; *** 31-Mar-04 LeeH
;          (princ (strcat "\n swapping out block " blktodo " with "
;                  GBL_swap_wdm_path " version..."))
          (princ (strcat "\n " (c:wd_msg "SWAP024" (list blktodo GBL_swap_wdm_path) "swapping out block %1 with %2 version")))
          (setq x (c:wd_bswap_libswap (list ben) GBL_swap_wdm_path 1 1 nil nil))
        )
        ((= todo 1) ; convert to new layer names found on new WD_M or WD_PNLM block
          (setq lcnt 0)
          (cond
            ((= blktodo "WD_M")
              (setq GBL_wd_m nil)
              (c:wd_reread_dwg_params)
              (setq old_wd_m GBL_wd_m)
            )
            ((= blktodo "WD_PNLM")
              (setq GBL_wd_pnlm nil)
              (c:wd_reread_pnldwg_params)
              (setq old_wd_m GBL_wd_pnlm)
          ) )

          (setq oldnam blktodo)
          (setq x 0)
          (setq newnam (strcat oldnam (itoa x)))
          (while (tblsearch "BLOCK" newnam)
            (setq x (1+ x))
            (setq newnam (strcat oldnam (itoa x)))
          )
          ; Okay,have unique name
          (command "_.RENAME" "_BLOCK" oldnam newnam) ; ** 21-May-04 NEHolt globalized keyword
          ; Now insert the new WD_M block at 0,0
          (setq x (entlast))
          (setvar "ATTREQ" 0)
          (setvar "ATTDIA" 0)
          (command "_.INSERT" (strcat GBL_swap_wdm_path blktodo) (list 0.0 0.0 0.0) "" "" "")
          (if (not (eq x (entlast)))
            (progn ; assume it went in
              ; Read layer/color list of new version of WD_M block
              (setq newben (entlast))
              (cond
                ((= blktodo "WD_M")
; ** 09-Apr-99 NEHolt
                  ; Transfer existing SHEET and SHEETDWGNAME attrib values
                  (if (nth 13 old_wd_m)
                    (c:wd_modattrval newben "SHEET" (nth 13 old_wd_m) nil))
                  (if (nth 46 old_wd_m)
                    (c:wd_modattrval newben "SHEETDWGNAME" (nth 46 old_wd_m) nil))
; **
                  (setq GBL_wd_m nil)
                  (c:wd_reread_dwg_params)
                  ; Now, for each layer category, check if new layer name
                  ; is different from the old layer name. If different, go
                  ; through database and move all ents on the old layer to the
                  ; new layer name.
                  (foreach ix
                     (list 27 28 29 32 33 34 35 36 37 38 39 40 44 45 48 54)
                    (if (AND (nth ix old_wd_m) (nth ix GBL_wd_m)
                        (/= (nth ix old_wd_m) "") (/= (nth ix GBL_wd_m) "")
                        (/= (nth ix old_wd_m) (nth ix GBL_wd_m)))
                      (progn ; Okay, category's new layer name diff from old
                        (setq lcnt (1+ lcnt))
; *** 31-Mar-04 LeeH
;                        (princ "\nChange ")
;                        (princ (nth ix old_wd_m))
;                        (princ " to ")
;                        (princ (nth ix GBL_wd_m))
                        (princ (strcat "\n" (c:wd_msg "SWAP035" (list (nth ix old_wd_m) (nth ix GBL_wd_m)) "Change %1 to %2")))
                        (setq cnt 0)
                        (setq en (entnext)) ; get first ent in database
                        (while en
                          (setq ed (entget en))
                          (if (cdr (assoc 8 ed))
                            (progn
                              (if (eq (cdr (assoc 8 ed)) (nth ix old_wd_m))
                                (progn ; found ent that needs to be moved to new lay
                                  (setq newed (subst (cons 8 (nth ix GBL_wd_m))
                                    (assoc 8 ed) ed))
                                  (if newed
                                    (progn
                                      (entmod newed)
                                      (setq cnt (1+ cnt))
                          ) ) ) ) ) )
                          (setq en (entnext en))
                        )
; *** 31-Mar-04 LeeH
;                        (princ ", ents moved: ")
                        (princ (strcat ", " (c:wd_msg "SWAP036" nil "ents moved") ": "))
                        (princ cnt)
                      )
                    )
                    (setq ix (1+ ix))
                  )
                  
; ** 17-Aug-05 NEHolt
                  ; Check WIRE layer list (not sure this is useful anymore since we've gone to Xrecords for wire type info - 05-Sep-06 NEHolt)
                  (setq existing_wiretype_lst (ace_get_active_dwg_wiretype nil)) ; get any define wire types already on drawing
                  (if (AND (nth 26 old_wd_m) (nth 26 GBL_wd_m)
                           (/= (nth 26 old_wd_m) "")
                           (/= (nth 26 GBL_wd_m) "")
                           (/= (nth 26 old_wd_m) (nth 26 GBL_wd_m)))
                    (progn ; Okay, WIRE layer list is different from the old list. Process all
                           ; LINE entities and find those that are wires per old WD_M block and
                           ; check against new layer name list.
                      (setq old_wd_m_wirelay_lst (nth 26 old_wd_m)) ; old wire layer list
                      (setq swap_wd_m_wirelay_lst (nth 26 GBL_wd_m)) ; new swaped block's wire layer list
                      (setq default_wirelay_nam (wd_lay_get_default_wire_lay)) ; default wire layer name to use
                      (setq ss (ssget "_X" '((0 . "LINE"))))
                      (if (AND default_wirelay_nam (/= ss nil))
                        (progn ; this drawing has LINE entities, process each one
                          (princ (c:wd_msg "CFG060" nil "Wire layers"))
                          (princ "\n")
                          (setq slen (sslength ss))
                          (setq ix 0)
                          (while (< ix slen)
                            (setq en (ssname ss ix)) ; next wire object to process
                            (setq ix (1+ ix)) ; increment counter for next time
                            (setq ed (entget en)) ; open the LINE entity
                            (setq existing_laynam (ace_strcase (cdr (assoc 8 ed)))) ; get its layer name
                            ; Check if this LINE entity is on a wire layer defined on original WD_M block
                            (setq hit nil)
                            (setq wildcard_hit nil) ; ** 30-Aug-06 NEHolt - 682593                            
; ** 05-Sep-06 NEHolt                            
                            (foreach x existing_wiretype_lst
                              (if (AND (not hit) (= existing_laynam (ace_strcase x))) (setq hit 1))
                            ) 
                            (if (not hit)
                              (progn ; this LINE is not on a layer currently defined in the WIRETYPE list
; **                            
                                (foreach x old_wd_m_wirelay_lst                              
                                  (if (AND (not hit) (wcmatch existing_laynam (ace_strcase x))) (setq hit 1))
                                )
                                (if hit
                                  (progn ; this LINE entity is on a wire layer. Make sure that this layer is
                                         ; also listed in new WD_M block. If it is not, then move this wire to
                                         ; the first (or only) layer in the new wire layer list.
                                    (setq hit nil)
                                    (foreach x swap_wd_m_wirelay_lst
                                      (if (AND (not hit) (wcmatch existing_laynam (ace_strcase x))) (setq hit 1))
                                    )
; ** 30-Aug-06 NEHolt - 682593                                
                                    (if (not hit)
                                      (progn ; try again, this time use wild card matching
                                        (foreach x swap_wd_m_wirelay_lst
                                          (if (not wildcard_hit)
                                            (progn 
                                              (if (OR (wcmatch existing_laynam (strcat "*" (ace_strcase x) "*"))                                                                                          
                                                      (wcmatch (ace_strcase x) (strcat "*" existing_laynam "*")))
                                                (progn
                                                  (setq wildcard_hit x) ; save the wild-card matched new layer name
                                              ) )
                                          ) )
                                        )
                                        (if wildcard_hit
                                          (progn
                                            (setq newed (subst (cons 8 wildcard_hit) (assoc 8 ed) ed))
                                            (if newed
                                              (progn ; okay to update the existing LINE entity's layer assignment
                                                (entmod newed)
                                                (entupd en)
                                                (setq wcnt (1+ wcnt))
                                                (princ (c:wd_msg "VIS020" (list existing_laynam wildcard_hit) "%1 --> %2"))
                                                (princ "\n")
                                                (setq hit 1) ; remember that change has been made
                                    ) ) ) ) ) ) 
; ** 30-Aug-06 NEHolt.en                                             
                                    (if (not hit)
                                      (progn ; problem, the LINE entity is no longer on a wire layer. Move it to
                                             ; the first layer listed in the new WD_M block's WIRELAY list
                                        (setq newed (subst (cons 8 default_wirelay_nam) (assoc 8 ed) ed))
                                        (if newed
                                          (progn ; okay to update the existing LINE entity's layer assignment
                                            (entmod newed)
                                            (entupd en)
                                            (setq wcnt (1+ wcnt))
                                            (princ (c:wd_msg "VIS020" (list existing_laynam default_wirelay_nam) "%1 --> %2"))
                                            (princ "\n")
                      ) ) ) ) ) ) ) ) ) ) )                        
                  ) )
; ** 17-Aug-05 NEHolt.en                                    
                )
                ((= blktodo "WD_PNLM")
                  (setq GBL_wd_pnlm nil)
                  (c:wd_reread_pnldwg_params)
                  ; Now, for each layer category, check if new layer name
                  ; is different from the old layer name. If different, go
                  ; through database and move all ents on the old layer to the
                  ; new layer name.
                  (foreach ix
                     (list 18 19 20 21 22 23 24 25 26 27 28 29 30 32 33 34 36)
                    (if (AND (nth ix old_wd_m) (nth ix GBL_wd_pnlm)
                        (/= (nth ix old_wd_m) "") (/= (nth ix GBL_wd_pnlm) "")
                        (/= (nth ix old_wd_m) (nth ix GBL_wd_pnlm)))
                      (progn ; Okay, category's new layer name diff from old
                        (setq lcnt (1+ lcnt))
; *** 31-Mar-04 LeeH
;                        (princ "\nChange ")
;                        (princ (nth ix old_wd_m))
;                        (princ " to ")
;                        (princ (nth ix GBL_wd_pnlm))
                        (princ (strcat "\n" (c:wd_msg "SWAP035" (list (nth ix old_wd_m) (nth ix GBL_wd_pnlm)) "Change %1 to %2")))
                        (setq cnt 0)
                        (setq en (entnext)) ; get first ent in database
                        (while en
                          (setq ed (entget en))
                          (if (cdr (assoc 8 ed))
                            (progn
                              (if (eq (cdr (assoc 8 ed)) (nth ix old_wd_m))
                                (progn ; found ent that needs to be moved to new lay
                                  (setq newed (subst (cons 8 (nth ix GBL_wd_pnlm))
                                    (assoc 8 ed) ed))
                                  (if newed
                                    (progn
                                      (entmod newed)
                                      (setq cnt (1+ cnt))
                          ) ) ) ) ) )
                          (setq en (entnext en))
                        )
; *** 31-Mar-04 LeeH
;                        (princ ", ents moved: ")
                        (princ (strcat ", " (c:wd_msg "SWAP036" nil "ents moved") ": "))
                        (princ cnt)
                      )
                    )
                    (setq ix (1+ ix))
                  )


                )
              )

; *** 31-Mar-04 LeeH
;              (if (= lcnt 0) (princ "\n No layer names were changed"))
              (if (= lcnt 0) (princ (strcat "\n " (c:wd_msg "SWAP037" nil "No layer names were changed"))))
; ** 17-Aug-05 NEHolt              
              (if (AND (> wcnt 0) (car swap_wd_m_wirelay_lst)) 
                (princ (strcat "\n " (c:wd_msg "CIRC012" (list (itoa wcnt) default_wirelay_nam) "%1 Line entities moved to a valid Wire layer (%2)")))
              )  
; **              
            )
          )
          ; Now erase old, renamed WD_M
          (if ben (entdel ben))
        )
      )

      (if (AND (/= todo nil) (= blktodo "WD_M"))
        (progn ; ok to continue
          (princ "\n")
          ; Now re-read the block
          (setq ss nil)
          (setq ss (ssget "_X" '((-4 . "<AND")(0 . "INSERT")(2 . "WD_M")(-4 . "AND>"))))
          (if (/= ss nil)
            (progn
              (setq newben (ssname ss 0))
              (if (eq ben newben)
                (progn ; failed
; *** 31-Mar-04 LeeH
;                  (princ "\n Failed to swap out WD_M block")
                  (princ (strcat "\n " (c:wd_msg "SWAP038" nil "Failed to swap out WD_M block")))
                )
              ; ELSE
                (progn ; Okay, success so far. Check for attrib WIREREF-LAY
                  (setq cnt 0)
                  (setq val (c:wd_getattrval newben "WIREREF_LAY"))
                  (if (AND val (/= val "")) ; new WD_M has WIREREF-LAY defined
                    (progn ; Process all block inserts. Look for attrib
                           ; WIRENO not on a WN_WD* block. For each one
                           ; found, flip the attrib layer to layer defined
                       ; by value of WIREREF_LAY attrib on new WD_M block
; *** 31-Mar-04 LeeH
;                      (princ "\n Processing terminal and signal arrow wire number text...")
                      (princ (strcat "\n " (c:wd_msg "SWAP039" nil "Processing terminal and signal arrow wire number text...")))
                      (setq ss (ssget "_X" '((0 . "INSERT"))))
                      (setq slen (sslength ss))
                      (setq ix 0)
                      (while (< ix slen)
                        (setq en (ssname ss ix))
                        (setq ed (entget en))
                        (setq symnam (cdr (assoc 2 ed)))
                        (if (not (wcmatch symnam "WD_WN*"))
                          (progn ; not a wire number block, process this one
                            (setq x (wd_get_attr_val_nam_en en "WIRENO"))
                            (if (car x)
                              (progn ; Yes, hit WIRENO attrib that is NOT part
                                 ; of a wire number block. Change attrib layer
                                 ; to value carried on WD_M block's WIREREF-LAY
                                (setq edd (entget (car x)))
                                (setq newed (subst (cons 8 val) (assoc 8 edd) edd))
                                (if newed (entmod newed))
                                (setq cnt (1+ cnt))
                        ) ) ) )
                        (setq ix (1+ ix))
                      )
                      (setq ss nil)
                      (princ "\n   ")
                      (princ cnt)
; *** 31-Mar-04 LeeH
;                      (princ " WIRE TERM and SIG ARROW text ents moved to layer ")
                      (princ (strcat " " (c:wd_msg "SWAP040" nil "WIRE TERM and SIG ARROW text ents moved to layer") " "))
                      (princ val)
  ) ) ) ) ) ) ) ) ) )
  (command "_.UNDO" "_E")
  (if #cmdecho (setvar "CMDECHO" #cmdecho))
  (setq *error* err_old)     ; Restore standard *error* handler
  (princ "\n")
  (command "_.REGEN")
  (princ)
)
; -- User entry points (can be batched via script file)
(defun c:swap_wdm_keep ( / )
  (do_swap_wdm 0 "S") ; swap but keep existing drawing's layers
)
; --
(defun c:swap_wdm ( / )
  (do_swap_wdm 1 "S") ; swap and convert to any new layers carried by wd_m.dwg
)
(defun c:swap_pnlm_keep ( / )
  (do_swap_wdm 0 "P") ; swap but keep existing drawing's layers
)
; --
(defun c:swap_pnlm ( / )
  (do_swap_wdm 1 "P") ; swap and convert to any new layers carried by wd_m.dwg
)
; *** 31-Mar-04 LeeH
;(princ "\nPANEL:")
;(princ "\n Type \"swap_pnlm\" to swap and conv to new lays carried on new wd_pnlm.dwg")
;(princ "\n Type \"swap_pnlm_keep\" to swap but keep drawing's existing layer names")
;(princ "\nSCHEMATICS:")
;(princ "\n Type \"swap_wdm\" to swap and convert to new layers carried on new wdm.dwg")
;(princ "\n Type \"swap_wdm_keep\" to swap but keep drawing's existing layer names")
(princ (strcat "\n" (c:wd_msg "SWAP041" nil "PANEL:")))
(princ (strcat "\n " (c:wd_msg "SWAP042" (list "\"swap_pnlm\"" "wd_pnlm.dwg") "Type %1 to swap and conv to new lays carried on new %2")))
(princ (strcat "\n " (c:wd_msg "SWAP043" (list "\"swap_pnlm_keep\"") "Type %1 to swap but keep drawing's existing layer names")))
(princ (strcat "\n" (c:wd_msg "SWAP044" nil "SCHEMATICS:")))
(princ (strcat "\n " (c:wd_msg "SWAP042" (list "\"swap_wdm\"" "wdm.dwg") "Type %1 to swap and conv to new lays carried on new %2")))
(princ (strcat "\n " (c:wd_msg "SWAP043" (list "\"swap_wdm_keep\"") "Type %1 to swap but keep drawing's existing layer names")))
(princ)
